﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Celeste;
using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.SusanHelper
{
	[CustomEntity("SusanHelper/NewPablo")]
	public class NewPablo : Actor
	{

		//Params
		public float speed;
		private bool god; 
		private bool noGrav;
		private int dashes;

		//Collision Data
		public Sprite sprite;
		public Hitbox hitbox;
		private Circle head;
		private Hitbox body;
		private ColliderList list = new ColliderList();

		//Movement
		private float vertSpd, currentSpeed = 0f;

		//New Params
		private string colorHash = "ffffff";
		private Color color = Color.White;


		private string altHash = "ff0000";
		private float counter;
		private float cycleLength = 3f;

		private int facing = -1;



		public NewPablo(Vector2 position, float speed, int dashes, bool god, bool noGrav, bool goat) : base(position)
		{
			Position.Y -= 1;

			this.noGrav = noGrav;
			this.god = god;
			this.dashes = dashes;
			this.speed = speed / 10;

			sprite = SusanModule.SpriteBank.Create("pablo_new");
			Add(sprite);

			head = new Circle(6, 4);
			body = new Hitbox(20f, 6f, -10f, 2f);
			list.Add(head, body);
			base.Collider = list;

			Add(new PlayerCollider(OnPlayer, list));

			sprite.Color = color = Color.Green;// Calc.HexToColor(colorHash);

			if(facing == -1)
			{
				//sprite.Scale.X = facing;
			}

		}


		public NewPablo(EntityData data, Vector2 offset) : this(data.Position + offset, data.Float("speed", 2f), data.Int("dashes", 1), data.Bool("god", defaultValue: false), data.Bool("noGrav", defaultValue: false), data.Bool("goat", defaultValue: false))
		{
		}


		private float sign = 1f;
		public override void Update()
		{
			base.Update();
			sprite.Visible = true;
			currentSpeed = Calc.Approach(speed, currentSpeed, Engine.DeltaTime);
			MoveH(currentSpeed);
			vertSpd = base.OnGround() ? 0f : Calc.Approach(0.75f, vertSpd, Engine.DeltaTime);
			if (!noGrav)
			{
				MoveV(god ? -2f*vertSpd : 2f*vertSpd);
			}
			sprite.Scale.X = speed > 0 ? 1f : -1f;


			if (CollideFirst<Solid>(Position + (currentSpeed < 0f ? -2 : 2) * Vector2.UnitX) != null)
			{
				speed *= -1;
				head.Position.X -= speed < 0 ? 8 : -8;
			}

			sign = counter > cycleLength ? -1f : counter < 0f ? 1f : sign;
			counter += Engine.DeltaTime * sign;
			sprite.Color = color; // Color.Lerp(Calc.HexToColor(colorHash), Calc.HexToColor(altHash), counter / cycleLength);
		}
		private void OnPlayer(Player player)
		{

			if (color == Color.Green)
			{
				Vector2 launch = new Vector2(player.CenterX < head.CenterX ? -1f : 1f, -0.2f).SafeNormalize() * 0.5f;
				player.ExplodeLaunch(launch, true);
				if (player.CenterX < CenterX)
					player.Speed.X *= -1f;

			}
			else
			{
				if (player.Speed.Y >= 0)
				{
					player.Bounce(base.Top);
					player.Speed *= 1.2f;
					Audio.Play("event:/new_content/game/10_farewell/puffer_boop", Position);
					player.Dashes = dashes;

				}
			}
		}

	}
}
